library(nlme)
library(multcomp)

load(file="data.Rdata")
attach(data)
summary(data)

valeurs.cible.y<-c(276,2091,2579,3826)
valeurs.cible.2<-c(406,1599,2703,3985)

##############################################
#Formants measurements modelling for vowel /y/
##############################################
Y <-data$Y[data$V=="y"]
formant<-data$formant[data$V=="y"]
subject<-data$sujet[data$V=="y"]
levels(subject)<-c(7,1,8:13,2:6)
trial<-data$trial[data$V=="y"]
stage <- data$Stage[data$V=="y"]
levels(stage)<-c("Before","After")
summary(data.frame(Y,formant,subject,trial,stage))

### Figure 1 : Individual boxplots of each formant and each formant-distance before (white) and after
#(grey) training for non-native vowel /y/. Solid lines correspond to reference values in the French
#language (Georgeton and colleagues (2012)).

#Formant
par(mfrow=c(2,2))
i=1
for (FF in c("F1","F2","F3","F4")){
  data.Y<-list(
  Y[(formant==FF)&(stage=="Before")&(subject=="1")],
  Y[(formant==FF)&(stage=="After")&(subject=="1")],
  Y[(formant==FF)&(stage=="Before")&(subject=="2")],
  Y[(formant==FF)&(stage=="After")&(subject=="2")],
  Y[(formant==FF)&(stage=="Before")&(subject=="3")],
  Y[(formant==FF)&(stage=="After")&(subject=="3")],
  Y[(formant==FF)&(stage=="Before")&(subject=="4")],
  Y[(formant==FF)&(stage=="After")&(subject=="4")],
  Y[(formant==FF)&(stage=="Before")&(subject=="5")],
  Y[(formant==FF)&(stage=="After")&(subject=="5")],
  Y[(formant==FF)&(stage=="Before")&(subject=="6")],
  Y[(formant==FF)&(stage=="After")&(subject=="6")])
boxplot(data.Y,col=c("white","grey"),
        horizontal=TRUE,
        names=c("1","","2","","3","","4","","5","","6",""),
        xlab=FF)
abline(v=valeurs.cible.y[i])
i<-i+1
}

#Formant-distance
par(mfrow=c(1,3))
Diff1.2<-Y[(formant=="F2")]-Y[(formant=="F1")]
Diff2.3<-Y[(formant=="F3")]-Y[(formant=="F2")]
Diff3.4<-Y[(formant=="F4")]-Y[(formant=="F3")]

data.Y<-list(
  Diff1.2[(stage=="Before")&(subject=="1")],
  Diff1.2[(stage=="After")&(subject=="1")],
  Diff1.2[(stage=="Before")&(subject=="2")],
  Diff1.2[(stage=="After")&(subject=="2")],
  Diff1.2[(stage=="Before")&(subject=="3")],
  Diff1.2[(stage=="After")&(subject=="3")],
  Diff1.2[(stage=="Before")&(subject=="4")],
  Diff1.2[(stage=="After")&(subject=="4")],
  Diff1.2[(stage=="Before")&(subject=="5")],
  Diff1.2[(stage=="After")&(subject=="5")],
  Diff1.2[(stage=="Before")&(subject=="6")],
  Diff1.2[(stage=="After")&(subject=="6")])
  boxplot(data.Y,col=c("white","grey"),
          horizontal=TRUE,
          names=c("1","","2","","3","","4","","5","","6",""),
          xlab="F2-F1")
  abline(v=valeurs.cible.y[2]-valeurs.cible.y[1])

  
  data.Y<-list(
    Diff2.3[(stage=="Before")&(subject=="1")],
    Diff2.3[(stage=="After")&(subject=="1")],
    Diff2.3[(stage=="Before")&(subject=="2")],
    Diff2.3[(stage=="After")&(subject=="2")],
    Diff2.3[(stage=="Before")&(subject=="3")],
    Diff2.3[(stage=="After")&(subject=="3")],
    Diff2.3[(stage=="Before")&(subject=="4")],
    Diff2.3[(stage=="After")&(subject=="4")],
    Diff2.3[(stage=="Before")&(subject=="5")],
    Diff2.3[(stage=="After")&(subject=="5")],
    Diff2.3[(stage=="Before")&(subject=="6")],
    Diff2.3[(stage=="After")&(subject=="6")])
  boxplot(data.Y,col=c("white","grey"),
          horizontal=TRUE,
          names=c("1","","2","","3","","4","","5","","6",""),
          xlab="F3-F2")
  abline(v=valeurs.cible.y[3]-valeurs.cible.y[2])
  
  data.Y<-list(
    Diff3.4[(stage=="Before")&(subject=="1")],
    Diff3.4[(stage=="After")&(subject=="1")],
    Diff3.4[(stage=="Before")&(subject=="2")],
    Diff3.4[(stage=="After")&(subject=="2")],
    Diff3.4[(stage=="Before")&(subject=="3")],
    Diff3.4[(stage=="After")&(subject=="3")],
    Diff3.4[(stage=="Before")&(subject=="4")],
    Diff3.4[(stage=="After")&(subject=="4")],
    Diff3.4[(stage=="Before")&(subject=="5")],
    Diff3.4[(stage=="After")&(subject=="5")],
    Diff3.4[(stage=="Before")&(subject=="6")],
    Diff3.4[(stage=="After")&(subject=="6")])
  boxplot(data.Y,col=c("white","grey"),
          horizontal=TRUE,
          names=c("1","","2","","3","","4","","5","","6",""),
          xlab="F4-F3")
  abline(v=valeurs.cible.y[4]-valeurs.cible.y[3])
  

### Model M0 (equation (1))
fitM0.Vy <- lme(Y ~ formant*stage, random=~1|subject, method="ML")
summary(fitM0.Vy)
resM0.Vy.std<-residuals(fitM0.Vy,type="pearson")

### Figure 3 : Standardized residuals by formant (left) and stage (right) for each subject for model M0
plot(fitM0.Vy,subject~resM0.Vy.std|formant,abline=0,xlim=c(-5,5),
     xlab="Standardized residuals")
plot(fitM0.Vy,subject~resM0.Vy.std|stage,abline=0,xlim=c(-5,5),
     xlab="Standardized residuals")

### Model M1 (equation (2))
fitM1.Vy <- lme(Y ~ formant*stage, 
                random=list(subject=pdBlocked(list(pdIdent(~1),
                                                 pdIdent(~formant-1)))),
                method="ML")
summary(fitM1.Vy)
resM1.Vy.std<-residuals(fitM1.Vy,type="pearson")

### Figure 4 : Standardized residuals by formant (left) and stage (right) for each subject for model M1
plot(fitM1.Vy,subject~resM1.Vy.std|formant,abline=0,xlim=c(-5,5),
     xlab="Standardized residuals")
plot(fitM1.Vy,subject~resM1.Vy.std|stage,abline=0,xlim=c(-5,5),
     xlab="Standardized residuals")

### Model M2
fitM2.Vy <- lme(Y~ formant*stage, 
                random=list(subject=pdBlocked(list(pdIdent(~1),
                                                 pdDiag(~formant-1)))),
                method="ML")
summary(fitM2.Vy)
resM2.Vy.std<-residuals(fitM2.Vy,type="pearson")

### Figure 5 : Standardized residuals by formant (left) and stage (right) for each subject for model M2
plot(fitM2.Vy,subject~resM2.Vy.std|formant,abline=0,xlim=c(-5,5),
     xlab="Standardized residuals")
plot(fitM2.Vy,subject~resM2.Vy.std|stage,abline=0,xlim=c(-5,5),
     xlab="Standardized residuals")

anova(fitM1.Vy,fitM2.Vy)

### Model M3
fitM3.Vy <- lme(Y ~ formant*stage, 
                random=list(subject=pdBlocked(list(pdIdent(~1),
                                                 pdDiag(~formant-1)))),
                weights=varIdent(form=~1|formant),
                method="ML",control=lmeControl(niterEM=200))
summary(fitM3.Vy)
resM3.Vy.std<-residuals(fitM3.Vy,type="pearson")

### Figure 6 : Standardized residuals by formant (left) and stage (right) for each subject for model M3
plot(fitM3.Vy,subject~resM3.Vy.std|formant,abline=0,xlim=c(-5,5),
     xlab="Standardized residuals")
plot(fitM3.Vy,subject~resM3.Vy.std|stage,abline=0,xlim=c(-5,5),
     xlab="Standardized residuals")

anova(fitM0.Vy,fitM1.Vy,fitM2.Vy,fitM3.Vy)


### Residuals correlation by formant and by stage obtained from model M3
op<-par(mfrow=c(1,1))
F1.resM3.Vy.std<-resM3.Vy.std[formant=="F1"]
F2.resM3.Vy.std<-resM3.Vy.std[formant=="F2"]
F3.resM3.Vy.std<-resM3.Vy.std[formant=="F3"]
F4.resM3.Vy.std<-resM3.Vy.std[formant=="F4"]
cor(cbind(F1.resM3.Vy.std,
          F2.resM3.Vy.std,
          F3.resM3.Vy.std,
          F4.resM3.Vy.std))
plot(data.frame(F1.resM3.Vy.std,
                F2.resM3.Vy.std,
                F3.resM3.Vy.std,
                F4.resM3.Vy.std),
     pch=as.numeric(stage),
     main="Residuals correlation by formant and by stage",col=as.numeric(stage))

#### Model M4
fitM4.Vy <- lme(Y ~ formant*stage, 
                random=list(subject=pdBlocked(list(pdIdent(~1),
                                                   pdDiag(~formant-1)))),
                weights=varIdent(form=~1|formant),
                correlation=corSymm(form=~1|subject/trial),
                method="ML",control=lmeControl(msMaxIter=1000))
summary(fitM4.Vy)
resM4.Vy.norm<-residuals(fitM4.Vy,type="normalized")

anova(fitM3.Vy,fitM4.Vy)

### Normalized residuals by formant (left) and stage (right) for each subject for model M4
plot(fitM4.Vy,subject~resM4.Vy.norm|formant,abline=0,xlim=c(-8,8),
       xlab="Normalized residuals",
       main="Normalized residuals by formant")
plot(fitM4.Vy,subject~resM4.Vy.norm|stage,abline=0,xlim=c(-8,8),
       xlab="Normalized residuals",
       main="Normalized residuals by stage")

### Residuals correlation by formant and by stage obtained from model M4
op<-par(mfrow=c(1,1))
F1.resM4.Vy.norm<-resM4.Vy.norm[formant=="F1"]
F2.resM4.Vy.norm<-resM4.Vy.norm[formant=="F2"]
F3.resM4.Vy.norm<-resM4.Vy.norm[formant=="F3"]
F4.resM4.Vy.norm<-resM4.Vy.norm[formant=="F4"]
cor(cbind(F1.resM4.Vy.norm,F2.resM4.Vy.norm,F3.resM4.Vy.norm,F4.resM4.Vy.norm))
plot(data.frame(F1.resM4.Vy.norm,F2.resM4.Vy.norm,F3.resM4.Vy.norm,F4.resM4.Vy.norm),
     main="Residuals correlation by formant and by stage",
     pch=as.numeric(stage[formant=="F1"]),
     col=as.numeric(stage[formant=="F1"]))

### Residuals correlation by formant before training
op<-par(mfrow=c(1,1))
F1.Before.resM4.Vy.norm<-resM4.Vy.norm[formant=="F1"&stage=="Before"]
F2.Before.resM4.Vy.norm<-resM4.Vy.norm[formant=="F2"&stage=="Before"]
F3.Before.resM4.Vy.norm<-resM4.Vy.norm[formant=="F3"&stage=="Before"]
F4.Before.resM4.Vy.norm<-resM4.Vy.norm[formant=="F4"&stage=="Before"]
cor(cbind(F1.Before.resM4.Vy.norm,
          F2.Before.resM4.Vy.norm,
          F3.Before.resM4.Vy.norm,
          F4.Before.resM4.Vy.norm))
plot(data.frame(F1.Before.resM4.Vy.norm,
                F2.Before.resM4.Vy.norm,
                F3.Before.resM4.Vy.norm,
                F4.Before.resM4.Vy.norm),
     main="Residuals correlation by formant before training",
     col=as.numeric(stage[formant=="F1"&stage=="Before"]))

### Residuals correlation by formant after training
op<-par(mfrow=c(1,1))
F1.After.resM4.Vy.norm<-resM4.Vy.norm[formant=="F1"&stage=="After"]
F2.After.resM4.Vy.norm<-resM4.Vy.norm[formant=="F2"&stage=="After"]
F3.After.resM4.Vy.norm<-resM4.Vy.norm[formant=="F3"&stage=="After"]
F4.After.resM4.Vy.norm<-resM4.Vy.norm[formant=="F4"&stage=="After"]
cor(cbind(F1.After.resM4.Vy.norm,
          F2.After.resM4.Vy.norm,
          F3.After.resM4.Vy.norm,
          F4.After.resM4.Vy.norm))
plot(data.frame(F1.After.resM4.Vy.norm,
                F2.After.resM4.Vy.norm,
                F3.After.resM4.Vy.norm,
                F4.After.resM4.Vy.norm),
     main="Residuals correlation by formant after training",
     col=as.numeric(stage[formant=="F1"&stage=="After"]))

#### Model M5
fitM5.Vy <- lme(Y ~ formant+stage, 
                random=list(subject=pdBlocked(list(pdIdent(~1),
                                                   pdDiag(~formant-1)))),
                weights=varIdent(form=~1|formant),
                correlation=corSymm(form=~1|subject/trial),
                method="ML",control=lmeControl(msMaxIter=1000))

summary(fitM5.Vy)
anova(fitM5.Vy,fitM4.Vy)


### Model M4 fitted using REML
fitM4.Vy.REML <- lme(Y ~ formant*stage, 
                random=list(subject=pdBlocked(list(pdIdent(~1),
                                                   pdDiag(~formant-1)))),
                weights=varIdent(form=~1|formant),
                correlation=corSymm(form=~1|subject/trial),
                method="REML",control=lmeControl(msMaxIter=1000))
summary(fitM4.Vy.REML)
resM4.Vy.norm.REML<-residuals(fitM4.Vy.REML,type="normalized")

### Figure 7 : Diagnostic plots for model M4
op<-par(mfrow=c(2,2))
hist(resM4.Vy.norm.REML, freq=FALSE,xlab="Normalized residuals", main="Histogram of the normalized residuals",
     xlim=c(-5,5),ylim=c(0,0.4))
lines((-500:500)/100, dnorm((-500:500)/100))
qqnorm(resM4.Vy.norm.REML)
qqline(resM4.Vy.norm.REML,col="red")
plot(resM4.Vy.norm.REML~fitted(fitM4.Vy.REML),xlab="Fitted values",ylab="Normalized residuals", main="Normalized residuals vs fitted values")
abline(h=0,col="red")
plot(fitted(fitM4.Vy.REML)~Y,xlab="Observed values",ylab="Fitted values", main="Fitted values vs observed values")
abline(0,1,col="red")



### R code for performing the statistical for Question 1 :
# Do formants already achieve the French reference value before training?
question1<-rbind('mu'=c(1,0,0,0,0,0,0,0),
              'mu+alpha2'=c(1,1,0,0,0,0,0,0),
              'mu+alpha3'=c(1,0,1,0,0,0,0,0),
              'mu+alpha4'=c(1,0,0,1,0,0,0,0))
summary(glht(fitM4.Vy.REML,linfct=question1,rhs=valeurs.cible.y))


### R code for performing the statistical for Question 2 :
# Do formants achieve the French reference value after training?
question2<-rbind('mu+betaAfter'=c(1,0,0,0,1,0,0,0),
                 'mu+alpha2+betaAfter+gamma2After'=c(1,1,0,0,1,1,0,0),
                 'mu+alpha3+betaAfter+gamma3After'=c(1,0,1,0,1,0,1,0),
                 'mu+alpha4+betaAfter+gamma4After'=c(1,0,0,1,1,0,0,1))
summary(glht(fitM4.Vy.REML,linfct=question2,rhs=valeurs.cible.y))


### R code for performing the statistical for Question 3 :
# Are formants similar before and after training?
question3<-rbind('betaAfter'=c(0,0,0,0,1,0,0,0),
              'betaAfter+gamma2After'=c(0,0,0,0,1,1,0,0),
              'betaAfter+gamma3After'=c(0,0,0,0,1,0,1,0),
              'betaAfter+gamma4After'=c(0,0,0,0,1,0,0,1))
summary(glht(fitM4.Vy.REML,linfct=question3))


### R code for performing the statistical for Question 4 :
# Is focalization before training already similar to that of French front vowels?
question4<-rbind('alpha2'=c(0,1,0,0,0,0,0,0),
                 'alpha3-alpha2'=c(0,-1,1,0,0,0,0,0),
                 'alpha4-alpha3'=c(0,0,-1,1,0,0,0,0))
summary(glht(fitM4.Vy.REML,linfct=question4,rhs=diff(valeurs.cible.y)))


### R code for performing the statistical for Question 5 :
# Is focalization after training similar to that of French front vowels?
question5<-rbind('alpha2+gamma2After'=c(0,1,0,0,0,1,0,0),
                 'alpha3-alpha2+gamma3After-gamma2After'=c(0,-1,1,0,0,-1,1,0),
                 'alpha4-alpha3+gamma4After-gamma3After'=c(0,0,-1,1,0,0,-1,1))
summary(glht(fitM4.Vy.REML,linfct=question5,rhs=diff(valeurs.cible.y)))


### R code for performing the statistical for Question 6 :
# Are distances between successive formants similar before and after training?
question6<-rbind('gamma2After'=c(0,0,0,0,0,1,0,0),
                 'gamma3After-gamma2After'=c(0,0,0,0,0,-1,1,0),
                 'gamma4After-gamma3After'=c(0,0,0,0,0,0,-1,1))
summary(glht(fitM4.Vy.REML,linfct=question6))




##############################################
#Formants measurements modelling for vowel /ø/
##############################################
Y.2 <-data$Y[data$V=="2"]
formant.2<-data$formant[data$V=="2"]
subject.2<-data$sujet[data$V=="2"]
levels(subject.2)<-c(7,1,8:13,2:6)
trial.2<-data$trial[data$V=="2"]
stage.2 <- data$Stage[data$V=="2"]
levels(stage.2)<-c("Before","After")
summary(data.frame(Y.2,formant.2,subject.2,trial.2,stage.2))


### Figure 2 : Individual boxplots of each formant and each formant-distance before (white) and after
# (grey) training for non-native vowel /ø/. Solid lines correspond to reference values in the French
# language (Georgeton and colleagues (2012)).

#Formant
par(mfrow=c(2,2))
i=1
for (FF in c("F1","F2","F3","F4")){
  data.Y.2<-list(
    Y.2[(formant.2==FF)&(stage.2=="Before")&(subject.2=="1")],
    Y.2[(formant.2==FF)&(stage.2=="After")&(subject.2=="1")],
    Y.2[(formant.2==FF)&(stage.2=="Before")&(subject.2=="2")],
    Y.2[(formant.2==FF)&(stage.2=="After")&(subject.2=="2")],
    Y.2[(formant.2==FF)&(stage.2=="Before")&(subject.2=="3")],
    Y.2[(formant.2==FF)&(stage.2=="After")&(subject.2=="3")],
    Y.2[(formant.2==FF)&(stage.2=="Before")&(subject.2=="4")],
    Y.2[(formant.2==FF)&(stage.2=="After")&(subject.2=="4")],
    Y.2[(formant.2==FF)&(stage.2=="Before")&(subject.2=="5")],
    Y.2[(formant.2==FF)&(stage.2=="After")&(subject.2=="5")],
    Y.2[(formant.2==FF)&(stage.2=="Before")&(subject.2=="6")],
    Y.2[(formant.2==FF)&(stage.2=="After")&(subject.2=="6")])
  boxplot(data.Y.2,col=c("white","grey"),
          horizontal=TRUE,
          names=c("1","","2","","3","","4","","5","","6",""),
          xlab=FF)
  abline(v=valeurs.cible.2[i])
  i<-i+1
}

#Formant-distance
par(mfrow=c(1,3))
Diff1.2<-Y.2[(formant.2=="F2")]-Y.2[(formant.2=="F1")]
Diff2.3<-Y.2[(formant.2=="F3")]-Y.2[(formant.2=="F2")]
Diff3.4<-Y.2[(formant.2=="F4")]-Y.2[(formant.2=="F3")]

data.Y.2<-list(
  Diff1.2[(stage.2=="Before")&(subject.2=="1")],
  Diff1.2[(stage.2=="After")&(subject.2=="1")],
  Diff1.2[(stage.2=="Before")&(subject.2=="2")],
  Diff1.2[(stage.2=="After")&(subject.2=="2")],
  Diff1.2[(stage.2=="Before")&(subject.2=="3")],
  Diff1.2[(stage.2=="After")&(subject.2=="3")],
  Diff1.2[(stage.2=="Before")&(subject.2=="4")],
  Diff1.2[(stage.2=="After")&(subject.2=="4")],
  Diff1.2[(stage.2=="Before")&(subject.2=="5")],
  Diff1.2[(stage.2=="After")&(subject.2=="5")],
  Diff1.2[(stage.2=="Before")&(subject.2=="6")],
  Diff1.2[(stage.2=="After")&(subject.2=="6")])
boxplot(data.Y.2,col=c("white","grey"),
        horizontal=TRUE,
        names=c("1","","2","","3","","4","","5","","6",""),
        xlab="F2-F1")
abline(v=valeurs.cible.2[2]-valeurs.cible.2[1])


data.Y.2<-list(
  Diff2.3[(stage.2=="Before")&(subject.2=="1")],
  Diff2.3[(stage.2=="After")&(subject.2=="1")],
  Diff2.3[(stage.2=="Before")&(subject.2=="2")],
  Diff2.3[(stage.2=="After")&(subject.2=="2")],
  Diff2.3[(stage.2=="Before")&(subject.2=="3")],
  Diff2.3[(stage.2=="After")&(subject.2=="3")],
  Diff2.3[(stage.2=="Before")&(subject.2=="4")],
  Diff2.3[(stage.2=="After")&(subject.2=="4")],
  Diff2.3[(stage.2=="Before")&(subject.2=="5")],
  Diff2.3[(stage.2=="After")&(subject.2=="5")],
  Diff2.3[(stage.2=="Before")&(subject.2=="6")],
  Diff2.3[(stage.2=="After")&(subject.2=="6")])
boxplot(data.Y.2,col=c("white","grey"),
        horizontal=TRUE,
        names=c("1","","2","","3","","4","","5","","6",""),
        xlab="F3-F2")
abline(v=valeurs.cible.2[3]-valeurs.cible.2[2])

data.Y.2<-list(
  Diff3.4[(stage.2=="Before")&(subject.2=="1")],
  Diff3.4[(stage.2=="After")&(subject.2=="1")],
  Diff3.4[(stage.2=="Before")&(subject.2=="2")],
  Diff3.4[(stage.2=="After")&(subject.2=="2")],
  Diff3.4[(stage.2=="Before")&(subject.2=="3")],
  Diff3.4[(stage.2=="After")&(subject.2=="3")],
  Diff3.4[(stage.2=="Before")&(subject.2=="4")],
  Diff3.4[(stage.2=="After")&(subject.2=="4")],
  Diff3.4[(stage.2=="Before")&(subject.2=="5")],
  Diff3.4[(stage.2=="After")&(subject.2=="5")],
  Diff3.4[(stage.2=="Before")&(subject.2=="6")],
  Diff3.4[(stage.2=="After")&(subject.2=="6")])
boxplot(data.Y.2,col=c("white","grey"),
        horizontal=TRUE,
        names=c("1","","2","","3","","4","","5","","6",""),
        xlab="F4-F3")
abline(v=valeurs.cible.2[4]-valeurs.cible.2[3])


### Model M0 (equation 1)
fitM0.V2 <- lme(Y.2 ~ formant.2*stage.2, random=~1|subject.2, method="ML")
summary(fitM0.V2)
resM0.V2.std<-residuals(fitM0.V2,type="pearson")

### Standardized residuals by formant (left) and stage (right) for each subject for model M0
plot(fitM0.V2,subject.2~resM0.V2.std|formant.2,abline=0,xlim=c(-5,5),
     xlab="Standardized residuals",main="Model M0.V2 par formant")
plot(fitM0.V2,subject.2~resM0.V2.std|stage.2,abline=0,xlim=c(-5,5),
     xlab="Standardized residuals",main="Model M0.V2 par étape")

### Model M1
fitM1.V2 <- lme(Y.2 ~ formant.2*stage.2, 
                random=list(subject.2=pdBlocked(list(pdIdent(~1),
                                                 pdIdent(~formant.2-1)))),
                method="ML")
summary(fitM1.V2)
resM1.V2.std<-residuals(fitM1.V2,type="pearson")

### Standardized residuals by formant (left) and stage (right) for each subject for model M1
plot(fitM1.V2,subject.2~resM1.V2.std|formant.2,abline=0,xlim=c(-5,5),
     xlab="Standardized residuals",main="Model M1.V2 par formant")
plot(fitM1.V2,subject.2~resM1.V2.std|stage.2,abline=0,xlim=c(-5,5),
     xlab="Standardized residuals",main="Model M1.V2 par étape")

### Model M2
fitM2.V2 <- lme(Y.2~ formant.2*stage.2, 
                random=list(subject.2=pdBlocked(list(pdIdent(~1),
                                                 pdDiag(~formant.2-1)))),
                method="ML")
summary(fitM2.V2)
resM2.V2.std<-residuals(fitM2.V2,type="pearson")

### Standardized residuals by formant (left) and stage (right) for each subject for model M2
plot(fitM2.V2,subject.2~resM2.V2.std|formant.2,abline=0,xlim=c(-5,5),
     xlab="Standardized residuals",main="Model M2.V2 par formant")
plot(fitM2.V2,subject.2~resM2.V2.std|stage.2,abline=0,xlim=c(-5,5),
     xlab="Standardized residuals",main="Model M2.V2 par étape")

### Model M3
fitM3.V2 <- lme(Y.2 ~ formant.2*stage.2, 
                random=list(subject.2=pdBlocked(list(pdIdent(~1),
                                                 pdDiag(~formant.2-1)))),
                weights=varIdent(form=~1|formant.2),
                method="ML")
summary(fitM3.V2)
resM3.V2.std<-residuals(fitM3.V2,type="pearson")

### Standardized residuals by formant (left) and stage (right) for each subject for model M3
plot(fitM3.V2,subject.2~resM3.V2.std|formant.2,abline=0,xlim=c(-5,5),
     xlab="Standardized residuals",main="Model M3.V2 par formant")
plot(fitM3.V2,subject.2~resM3.V2.std|stage.2,abline=0,xlim=c(-5,5),
     xlab="Standardized residuals",main="Model M3.V2 par groupe")

anova(fitM0.V2,fitM1.V2,fitM2.V2,fitM3.V2)

### Model M4
fitM4.V2 <- lme(Y.2 ~ formant.2*stage.2, 
                random=list(subject.2=pdBlocked(list(pdIdent(~1),
                                                     pdDiag(~formant.2-1)))),
                weights=varIdent(form=~1|formant.2),
                correlation=corSymm(form=~1|subject.2/trial.2),
                method="ML",control=lmeControl(msMaxIter=1000))
summary(fitM4.V2)
anova(fitM3.V2,fitM4.V2)
resM4.V2.norm<-residuals(fitM4.V2,type="normalized")

### Normalized residuals by formant (left) and stage (right) for each subject for model M4
plot(fitM4.V2,subject.2~resM4.V2.norm|stage.2,abline=0,xlim=c(-8,8),
     xlab="Normalized residuals")
plot(fitM4.V2,subject.2~resM4.V2.norm|formant.2,abline=0,xlim=c(-8,8),
     xlab="Normalized residuals")

### Model M5 (without stage effect)
fitM5.V2 <- lme(Y.2 ~ formant.2, 
                random=list(subject.2=pdBlocked(list(pdIdent(~1),
                                                     pdDiag(~formant.2-1)))),
                weights=varIdent(form=~1|formant.2),
                correlation=corSymm(form=~1|subject.2/trial.2),
                method="ML",control=lmeControl(msMaxIter=1000))
summary(fitM5.V2)
anova(fitM5.V2,fitM4.V2)


### Model M4 fitted using REML
fitM4.V2.REML <- lme(Y.2 ~ formant.2*stage.2, 
                random=list(subject.2=pdBlocked(list(pdIdent(~1),
                                                     pdDiag(~formant.2-1)))),
                weights=varIdent(form=~1|formant.2),
                correlation=corSymm(form=~1|subject.2/trial.2),
                method="REML",control=lmeControl(msMaxIter=1000))
summary(fitM4.V2.REML)
resM4.V2.std.REML<-residuals(fitM4.V2.REML,type="normalized")

### Diagnostic plots for model M4
op<-par(mfrow=c(2,2))
hist(resM4.V2.std.REML, freq=FALSE,xlab="Normalized residuals", main="Histogram of the normalized residuals",
     xlim=c(-5,5))
lines((-500:500)/100, dnorm((-500:500)/100))
qqnorm(resM4.V2.std.REML)
qqline(resM4.V2.std.REML,col="red")
plot(resM4.V2.std.REML~fitted(fitM3.V2.REML),xlab="Fitted values",ylab="Normalized residuals", main="Normalized residuals vs fitted values")
abline(h=0,col="red")
plot(fitted(fitM4.V2.REML)~Y.2,xlab="Observed values",ylab="Fitted values", main="Fitted values vs observed values")
abline(0,1,col="red")


### R code for performing the statistical for Question 1 :
# Do formants already achieve the French reference value before training?
summary(glht(fitM4.V2.REML,linfct=question1,rhs=valeurs.cible.2))


### R code for performing the statistical for Question 2 :
# Do formants achieve the French reference value after training?
summary(glht(fitM4.V2.REML,linfct=question2,rhs=valeurs.cible.2))


### R code for performing the statistical for Question 3 :
# Are formants similar before and after training?
summary(glht(fitM4.V2.REML,linfct=question3))


### R code for performing the statistical for Question 4 :
# Is focalization before training already similar to that of French front vowels?
summary(glht(fitM4.V2.REML,linfct=question4,rhs=diff(valeurs.cible.2)))


### R code for performing the statistical for Question 5 :
# Is focalization after training similar to that of French front vowels?
summary(glht(fitM4.V2.REML,linfct=question5,rhs=diff(valeurs.cible.2)))


### R code for performing the statistical for Question 6 :
# Are distances between successive formants similar before and after training?
summary(glht(fitM4.V2.REML,linfct=question6))



